package it.eng.eremita.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.types.Identifiable;
import it.eng.eremita.graphql.types.Trackable;
import it.eng.eremita.graphql.types.Validable;

@Entity
@Table(name="EREMITA_INTERVENTO")
@SequenceGenerator(name="SEQ_INTERVENTO", sequenceName="SEQ_INTERVENTO", initialValue=1, allocationSize=1)
public class Intervento implements Serializable,Identifiable<Long>,Trackable<Utente,Long>,Validable {

	

	Long id;
	String validato;
	Specie specie;
	String idScheda;
	String rilevatore;
	Date dataIntervento;
	SitoNatura2000 sito;
	BigDecimal coordinataX;
	BigDecimal coordinataY;
	String transetto;
	String info;
	String tipo;
	String sottotipo;
	String note;
	String ente;
	
	List<Documento> documenti;
	
	
	Utente utenteCreazione;
	Utente utenteModifica;
	Date dataCreazione;
	Date dataModifica;
	
	
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_INTERVENTO")
	@Column(name="ID")
	@GraphQLQuery(name="id",description="Id oggetto, univoco.")
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	
	@ManyToOne
	@JoinColumn(name="ID_SPECIE")
	@GraphQLQuery(name="specie",description="La specie del monitoraggio, tra quelle presenti in {specieProgettos}")
	public Specie getSpecie() {
		return specie;
	}

	public void setSpecie(Specie specie) {
		this.specie = specie;
	}
	
	
	@Column(name="ID_SCHEDA")
	@GraphQLQuery(name="idScheda")
	public String getIdScheda() {
		return idScheda;
	}

	public void setIdScheda(String idScheda) {
		this.idScheda = idScheda;
	}
	
	
	@Column(name="VALIDATO")
	public String getValidatoString() {
		return validato;
	}

	public void setValidatoString(String validato) {
		this.validato = validato;
	}
	
	@Transient
	@GraphQLQuery(name="validato")
	public Boolean getValidatoBoolean() {
		return (validato==null? null:(validato.equals("true")?true:false));
	}

	public void setValidatoBoolean(Boolean v) {
		if (v==null) validato = null;
		else if (v) validato = "true";
		else validato = "false";
	}

	@Column(name="RILEVATORI")
	@GraphQLQuery(name="rilevatori")
	public String getRilevatore() {
		return rilevatore;
	}

	public void setRilevatore(String rilevatore) {
		this.rilevatore = rilevatore;
	}

	@ManyToOne
	@JoinColumn(name="ID_SITO")
	@GraphQLQuery(name="sitoNatura2000",description="La lista dei valori possibili si ottiene con {sitoNatura2000s} e {sitoNatura2000SmartFilter}")
	public SitoNatura2000 getSito() {
		return sito;
	}

	public void setSito(SitoNatura2000 sito) {
		this.sito = sito;
	}

	@Column(name="TRANSETTO")
	@GraphQLQuery(name="transetto")
	public String getTransetto() {
		return transetto;
	}

	public void setTransetto(String transetto) {
		this.transetto = transetto;
	}

	
	@Column(name="COORDINATA_X")
	@GraphQLQuery(name="coordinataX")
	public BigDecimal getCoordinataX() {
		return coordinataX;
	}
	public void setCoordinataX(BigDecimal coordinataX) {
		this.coordinataX = coordinataX;
	}
	
	@Column(name="COORDINATA_Y")
	@GraphQLQuery(name="coordinataY")
	public BigDecimal getCoordinataY() {
		return coordinataY;
	}
	public void setCoordinataY(BigDecimal coordinataY) {
		this.coordinataY = coordinataY;
	}

	@Column(name="NOTE")
	@GraphQLQuery(name="note")
	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}
	
	@Column(name="ENTE")
	@GraphQLQuery(name="ente")
	public String getEnte() {
		return ente;
	}

	public void setEnte(String ente) {
		this.ente = ente;
	}
	
	
	@ManyToOne
	@JoinColumn(name="UTENTE_CREAZIONE")
	@GraphQLQuery(name="utenteCreazione")
	public Utente getUtenteCreazione() {
		return utenteCreazione;
	}

	public void setUtenteCreazione(Utente utenteCreazione) {
		this.utenteCreazione = utenteCreazione;
	}

	@ManyToOne
	@JoinColumn(name="UTENTE_MODIFICA")
	@GraphQLQuery(name="utenteModifica")
	public Utente getUtenteModifica() {
		return utenteModifica;
	}

	public void setUtenteModifica(Utente utenteModifica) {
		this.utenteModifica = utenteModifica;
	}
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_INTERVENTO")
	@GraphQLQuery(name="dataIntervento")
	public Date getDataIntervento() {
		return dataIntervento;
	}

	public void setDataIntervento(Date dataIntervento) {
		this.dataIntervento = dataIntervento;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_CREAZIONE")
	@GraphQLQuery(name="dataCreazione")
	public Date getDataCreazione() {
		return dataCreazione;
	}

	public void setDataCreazione(Date dataCreazione) {
		this.dataCreazione = dataCreazione;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_MODIFICA")
	@GraphQLQuery(name="dataModifica")
	public Date getDataModifica() {
		return dataModifica;
	}

	public void setDataModifica(Date dataModifica) {
		this.dataModifica = dataModifica;
	}
	
	

	@Column(name="INFO")
	//@Lob
	@GraphQLQuery(name="info")
	public String getInfo() {
		return info;
	}

	public void setInfo(String info) {
		this.info = info;
	}

	@Column(name="TIPO")
	@GraphQLQuery(name="tipo")
	public String getTipo() {
		return tipo;
	}

	public void setTipo(String tipo) {
		this.tipo = tipo;
	}
	
	@Column(name="SOTTOTIPO")
	@GraphQLQuery(name="sottotipo")
	public String getSottotipo() {
		return sottotipo;
	}

	public void setSottotipo(String sottotipo) {
		this.sottotipo = sottotipo;
	}
	
	
	@GraphQLQuery(name="documenti")
	@OneToMany(cascade=CascadeType.REMOVE,orphanRemoval=true)
	@JoinTable(name="EREMITA_INTERVENTO_DOC",
		joinColumns=@JoinColumn(name="INTERVENTO",referencedColumnName="ID"),
		inverseJoinColumns=@JoinColumn(name="DOCUMENTO",referencedColumnName="ID"))
	public List<Documento> getDocumenti() {
		return documenti;
	}

	public void setDocumenti(List<Documento> documenti) {
		this.documenti = documenti;
		if (documenti!=null && documenti.getClass().equals(ArrayList.class)) {
			for (Documento s : documenti) {
				s.setEntita("eremita_intervento");
				s.setIdEntita(this.getId());
			}
			
		}
		if (this.documenti==null) this.documenti = new ArrayList<Documento>();

	}

	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof Intervento)) return false;
		
		Intervento ms = (Intervento)o;
		return (ms.getId()==this.getId());

	}
	
	@Override
	public String toString() {
		return "Intervento-"+getId();
	}
	
	@Override
	public int hashCode() {
		return (int)( getId()%Integer.MAX_VALUE);
	}
	
}
